package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.setting.Settings;

import javax.annotation.Nonnull;

/**
 * Describes the repository hook settings
 *
 * @since 5.2
 */
public interface RepositoryHookSettings {

    /**
     * @return the scope at which the repository hook was configured
     */
    @Nonnull
    Scope getScope();

    /**
     * @return the settings
     */
    @Nonnull
    Settings getSettings();
}
