package com.atlassian.bitbucket.help;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A service for retrieving help URLs and related help information for a given help topic.
 */
public interface HelpPathService {

    /**
     * @param topicKey the non-null key for the help topic
     * @return the alt (tool tip) to be displayed for the help topic or null if one was not found for the help topic
     */
    @Nullable
    String getPageAlt(@Nonnull String topicKey);
    
    /**
     * @param topicKey the non-null key for the help topic
     * @return the Confluence page key for the help topic or null if one was not found for the help topic
     */
    @Nullable
    String getPageKey(@Nonnull String topicKey);
    
    /**
     * @param topicKey the non-null key for the help topic
     * @return the title to be displayed for the help topic or null if one was not found for the help topic
     */
    @Nullable
    String getPageTitle(@Nonnull String topicKey);

    /**
     * @param topicKey the non-null key for the help topic
     * @return the url for the help topic or null if one was not found for the help topic
     */
    @Nullable
    String getPageUrl(@Nonnull String topicKey);

    /** @return the prefix url for all help topics */
    @Nullable
    String getPrefix();
}
