package com.atlassian.bitbucket.event.tag;

import com.atlassian.bitbucket.event.repository.AbstractRepositoryRefsChangedEvent;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.Tag;

import javax.annotation.Nonnull;
import java.util.Collections;

import static java.util.Objects.requireNonNull;

/**
 * Base event for any operations on tags.
 *
 * @see TagCreatedEvent
 */
public class TagChangedEvent extends AbstractRepositoryRefsChangedEvent {

    private final Tag tag;

    public TagChangedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Tag tag,
                           @Nonnull RefChange refChange) {
        super(source, repository, Collections.singleton(refChange));

        this.tag = requireNonNull(tag, "tag");
    }

    @Nonnull
    public Tag getTag() {
        return tag;
    }
}
