package com.atlassian.bitbucket.event.server;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when the HTTP(S) SCM hosting is enabled or disabled.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
public class HttpScmHostingChangedEvent extends ApplicationConfigurationChangedEvent<Boolean> {

    public HttpScmHostingChangedEvent(@Nonnull Object source, @Nonnull Boolean oldValue, @Nonnull Boolean newValue) {
        super(source, Property.HTTP_SCM_HOSTING, requireNonNull(oldValue, "oldValue"), requireNonNull(newValue, "newValue"));
    }
}
