package com.atlassian.bitbucket.event.server;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when the application display name is changed.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
public class DisplayNameChangedEvent extends ApplicationConfigurationChangedEvent<String> {

    public DisplayNameChangedEvent(@Nonnull Object source, @Nullable String oldValue, @Nullable String newValue) {
        super(source, Property.DISPLAY_NAME, oldValue, newValue);
    }
}
