package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryForkRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when an attempt to fork a repository fails.
 * <p>
 * If forking was {@link RepositoryForkRequestedEvent#isCanceled() canceled}, this event will <i>not</i> be raised, as
 * forking did not fail--it was never attempted.
 *
 * @see RepositoryService#fork(RepositoryForkRequest)
 */
@AsynchronousPreferred
public class RepositoryForkFailedEvent extends RepositoryCreationFailedEvent {

    public RepositoryForkFailedEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source, repository);
    }
}
