package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Base class for all events related to repositories: pushes, pulls, merge operations, etc.
 * <p>
 * This event is internally audited.
 */
public abstract class RepositoryEvent extends ApplicationEvent {

    private final Repository repository;

    public RepositoryEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source);

        this.repository = requireNonNull(repository, "repository");
    }

    @Nonnull
    public Repository getRepository() {
        return repository;
    }
}
