package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;

import javax.annotation.Nonnull;
import java.util.Collection;

/**
 * Basic implementation of RepositoryRefsChangedEvent that developers can extend.
 */
@AsynchronousPreferred
public class AbstractRepositoryRefsChangedEvent extends RepositoryEvent implements RepositoryRefsChangedEvent {

    protected static final String EMPTY_HASH = Strings.repeat("0", 40);

    private final Collection<RefChange> refChanges;

    public AbstractRepositoryRefsChangedEvent(@Nonnull Object source, @Nonnull Repository repository,
                                              @Nonnull Collection<RefChange> refChanges) {
        super(source, repository);

        this.refChanges = ImmutableList.copyOf(refChanges);
    }

    @Nonnull
    @Override
    public Collection<RefChange> getRefChanges() {
        return refChanges;
    }
}
