package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a pending comment is added as a reply on a pull request.
 *
 * @since 7.7
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.review.comment.replied")
public class PullRequestReviewCommentRepliedEvent extends PullRequestReviewCommentEvent {

    /**
     * @param source        the component raising the event
     * @param pullRequest   the affected pull request
     * @param comment       the comment
     * @param parent        the parent of the comment
     */
    public PullRequestReviewCommentRepliedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                                @Nonnull Comment comment, @Nonnull Comment parent) {
        super(source, pullRequest, comment, parent, CommentAction.REPLIED);
    }
}
