package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when a pending comment is added or replied on a pull request.
 *
 * @since 7.7
 */
public abstract class PullRequestReviewCommentEvent extends PullRequestReviewEvent {

    private final Comment comment;
    private final CommentAction commentAction;
    private final Comment parent;

    /**
     * @param source        the component raising the event
     * @param pullRequest   the affected pull request
     * @param comment       the affected comment
     * @param parent        the parent of the comment, which will be {@code null} for top level comments
     * @param commentAction the action performed on the comment
     */
    protected PullRequestReviewCommentEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                         @Nonnull Comment comment, @Nullable Comment parent,
                                         @Nonnull CommentAction commentAction) {
        super(source, pullRequest, PullRequestAction.REVIEW_COMMENTED);

        this.comment = requireNonNull(comment, "comment");
        this.commentAction = requireNonNull(commentAction, "commentAction");
        this.parent = parent;
    }

    @Nonnull
    public Comment getComment() {
        return comment;
    }

    @Nonnull
    public CommentAction getCommentAction() {
        return commentAction;
    }

    @Nullable
    public Comment getParent() {
        return parent;
    }
}
