package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import java.util.Collection;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when a pull request is deleted.
 *
 * @since 5.1
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.deleted")
public class PullRequestDeletedEvent extends PullRequestEvent {

    private final Collection<Watcher> watchers;

    public PullRequestDeletedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                   @Nonnull Collection<Watcher> watchers) {
        super(source, pullRequest, PullRequestAction.DELETED);
        this.watchers = requireNonNull(watchers, "watchers");
    }

    /**
     * Listeners of this event aren't able to call {@link WatcherService#search} to find watchers of the pull request
     * because the pull request has already been deleted.
     *
     * @return the watchers of the pull request that was deleted
     */
    public Collection<Watcher> getWatchers() {
        return watchers;
    }
}
