package com.atlassian.bitbucket.event.permission;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;

/**
 * This event is fired when a user or group are granted a repository permission.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
public class RepositoryPermissionGrantedEvent extends RepositoryPermissionEvent implements PermissionGrantedEvent {

    public RepositoryPermissionGrantedEvent(Object source, Permission permission, Repository repository,
                                            String affectedGroup, ApplicationUser affectedUser) {
        super(source, permission, repository, affectedGroup, affectedUser);
    }
}
