package com.atlassian.bitbucket.event.permission;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;

/**
 * This event is fired when a user or group has their global permission revoked.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
public class GlobalPermissionRevokedEvent extends GlobalPermissionEvent implements PermissionRevokedEvent {

    public GlobalPermissionRevokedEvent(Object source, Permission permission,
                                        String affectedGroup, ApplicationUser affectedUser) {
        super(source, permission, affectedGroup, affectedUser);
    }
}
