package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Objects.requireNonNull;

/**
 * @see RepositoryPermissionModificationRequestedEvent
 * @see RepositoryPermissionModifiedEvent
 */
public abstract class AbstractRepositoryPermissionModificationEvent extends RepositoryPermissionEvent {

    private final Permission oldValue;

    protected AbstractRepositoryPermissionModificationEvent(Object source,
                                                            Permission oldValue, Permission newValue,
                                                            Repository repository,
                                                            String affectedGroup, ApplicationUser affectedUser) {
        super(source, newValue, repository, affectedGroup, affectedUser);

        this.oldValue = requireNonNull(oldValue, "oldValue");
        checkArgument(oldValue.isResource(Repository.class) && oldValue.isGrantable(), "oldValue must be a grantable repository permission");
    }

    @Nonnull
    public Permission getNewValue() {
        return getPermission();
    }

    @Nonnull
    public Permission getOldValue() {
        return oldValue;
    }
}
