package com.atlassian.bitbucket.event.migration;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when database migration fails.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
public class MigrationFailedEvent extends MigrationEndedEvent {

    public MigrationFailedEvent(@Nonnull Object source) {
        super(source);
    }
}
