package com.atlassian.bitbucket.event.mesh;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.mesh.MeshNode;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * A base class for constructing {@link MeshNodeEvent}s.
 *
 * @since 8.0
 */
public abstract class AbstractMeshNodeEvent extends ApplicationEvent implements MeshNodeEvent {

    private final MeshNode node;

    protected AbstractMeshNodeEvent(@Nonnull Object source, @Nonnull MeshNode node) {
        super(source);

        this.node = requireNonNull(node, "node");
    }

    /**
     * @return the node for which the event was raised
     */
    @Nonnull
    public MeshNode getNode() {
        return node;
    }

    /**
     * @return the node's {@link MeshNode#getId ID}
     */
    @Override
    public long getNodeId() {
        return node.getId();
    }
}
