package com.atlassian.bitbucket.event.branch;

import com.atlassian.bitbucket.hook.repository.AbstractRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.0
 */
public abstract class BranchHookRequest extends AbstractRepositoryHookRequest {

    private final Branch branch;

    protected BranchHookRequest(AbstractBuilder<?> builder) {
        super(builder);

        branch = builder.branch;
    }

    @Nonnull
    public Branch getBranch() {
        return branch;
    }

    protected abstract static class AbstractBuilder<B extends AbstractBuilder<B>>
            extends AbstractRepositoryHookRequest.AbstractBuilder<B> {

        private final Branch branch;

        protected AbstractBuilder(@Nonnull Repository repository, @Nonnull RepositoryHookTrigger trigger,
                                  @Nonnull Branch branch) {
            super(repository, trigger);

            this.branch = requireNonNull(branch, "branch");
        }
    }
}
