package com.atlassian.bitbucket.event.backup;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when a backup completes successfully.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
@EventName("stash.backup.success")
public class BackupSucceededEvent extends BackupEndedEvent {

    public BackupSucceededEvent(@Nonnull Object source) {
        super(source);
    }
}
