package com.atlassian.bitbucket.dashboard;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.validation.ArgumentValidationException;

import javax.annotation.Nonnull;

/**
 * Provides services for the Personal Dashboards.
 *
 * @since 4.10
 */
public interface DashboardService {

    /**
     * Retrieves a single page of suggestions for pull requests that a user may wish to raise. Such suggestions
     * are based on criteria specified in the {@link SuggestPullRequestsRequest request object} and for example
     * may be restricted to be based on pushes by a specific user.
     * <p>
     * Such suggestions are based on ref changes occurring and so contain the ref change that
     * prompted the suggestion plus the time the change event occurred. Changes will be returned in
     * descending order based on the time the change that prompted the suggestion occurred.
     *
     * @param request the request
     * @return page of pull request suggestions
     * @throws ArgumentValidationException  if "limit" contained within the {@link SuggestPullRequestsRequest request}
     *                                      is less than one or exceeds the maximum the service permits
     */
    Page<PullRequestSuggestion> suggestPullRequests(@Nonnull SuggestPullRequestsRequest request);
}
