package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

public class DiffSummary extends AbstractSummary {

    private final boolean truncated;

    private DiffSummary(Builder builder) {
        super(builder);
        truncated = builder.truncated;
    }

    /**
     * This is to indicate that some sort of truncation has taken place. Previously if a truncation has taken place at
     * the exact boundary of a diff there was no way of reporting back to the client that truncation has taken place.
     *
     * @return true if the diff was truncated in any way.
     */
    public boolean isTruncated() {
        return truncated;
    }

    public static class Builder extends AbstractBuilder<Builder, DiffSummary> {

        private boolean truncated;

        /**
         * Creates and initializes a new builder using details from the provided {@link AbstractSummary summary}.
         *
         * @param summary the summary to initialize this builder from
         */
        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        /**
         * Creates a new builder with the provided {@link CommandResult result}.
         *
         * @param result the operation result for the summary
         */
        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public DiffSummary build() {
            return new DiffSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }

        @Nonnull
        public Builder truncated(boolean value) {
            this.truncated = value;
            return this;
        }
    }
}
