package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.util.Page;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

public class SimpleChangeset implements Changeset {

    private final MinimalCommit fromCommit;
    private final Commit toCommit;
    private final Page<Change> changes;

    private SimpleChangeset(Builder builder) {
        fromCommit = builder.fromCommit;
        toCommit = builder.toCommit;
        changes = builder.changes;
    }

    @Override
    public Page<Change> getChanges() {
        return changes;
    }

    @Override
    public MinimalCommit getFromCommit() {
        return fromCommit;
    }

    @Nonnull
    @Override
    public Commit getToCommit() {
        return toCommit;
    }

    public static class Builder {

        private final Commit toCommit;

        private Page<Change> changes;
        private MinimalCommit fromCommit;

        public Builder(@Nonnull Commit toCommit) {
            this.toCommit = requireNonNull(toCommit, "toCommit");
        }

        @Nonnull
        public SimpleChangeset build() {
            return new SimpleChangeset(this);
        }

        @Nonnull
        public Builder changes(@Nullable Page<Change> value) {
            changes = value;

            return this;
        }

        @Nonnull
        public Builder fromCommit(@Nullable MinimalCommit value) {
            fromCommit = value;

            return this;
        }
    }
}
