package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

/**
 * Indicates the operation could not performed because the {@link Comment#getVersion() comment version}
 * has changed since the {@link Comment comment} was retrieved.
 *
 * @see Comment#getVersion()
 */
public class CommentOutOfDateException extends EntityOutOfDateException {

    private static final long serialVersionUID = 2L;
    
    public CommentOutOfDateException(KeyedMessage message, Throwable cause) {
        this(message, cause, UNKNOWN_VERSION, UNKNOWN_VERSION);
    }

    public CommentOutOfDateException(KeyedMessage message, int expectedVersion, int currentVersion) {
        super(message, expectedVersion, currentVersion);
    }

    public CommentOutOfDateException(KeyedMessage message, Throwable cause, int expectedVersion, int currentVersion) {
        super(message, cause, expectedVersion, currentVersion);
    }
}
