package com.atlassian.bitbucket.comment;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.0
 */
public class AddCommentReplyRequest {

    private final long parentId;
    private boolean pending;
    private final CommentSeverity severity;
    private final String text;

    private AddCommentReplyRequest(@Nonnull Builder builder) {
        parentId = builder.parentId;
        pending = builder.pending;
        severity = builder.severity;
        text = builder.text;
    }

    public long getParentId() {
        return parentId;
    }

    /**
     * @since 6.7
     */
    @Nullable
    public CommentSeverity getSeverity() {
        return severity;
    }

    @Nonnull
    public String getText() {
        return text;
    }

    /**
     * @since 7.7
     */
    public boolean isPending() {
        return pending;
    }

    public static class Builder {

        private final long parentId;
        private final String text;

        private boolean pending;
        private CommentSeverity severity;

        public Builder(long parentId, @Nonnull String text) {
            this.parentId = parentId;
            this.text = requireNonNull(text, "text");
        }

        @Nonnull
        public AddCommentReplyRequest build() {
            return new AddCommentReplyRequest(this);
        }

        /**
         * @since 7.7
         */
        @Nonnull
        public Builder pending(boolean value) {
            pending = value;
            return this;
        }

        /**
         * @since 6.7
         */
        @Nonnull
        public Builder severity(@Nullable CommentSeverity value) {
            severity = value;
            return this;
        }
    }
}
