package com.atlassian.bitbucket.cluster;

import com.atlassian.bitbucket.server.ApplicationState;

import javax.annotation.Nonnull;
import java.util.Map;

/**
 * Provides access to cluster details for the instance.
 */
public interface ClusterService {

    /**
     * @return details about the cluster and its {@link ClusterNode nodes}
     */
    @Nonnull
    ClusterInformation getInformation();

    /**
     * Convenience method for obtaining the ID for the local node. Calling the method is equivalent to calling
     * {@code getInformation().getLocalNode().getId()}
     *
     * @return the ID of the local node
     */
    @Nonnull
    String getNodeId();

    /**
     * Retrieve the current status of the individual cluster nodes. The nodes returned may be incomplete;
     * absence of a node should be considered a status of {@link ApplicationState#UNKNOWN UNKNOWN}.
     *
     * @return The status of the individual nodes that were available.
     * @throws ClusterExecutionException when execution on the remote nodes fails for any reason
     * @since 8.0
     */
    @Nonnull
    Map<ClusterNode, ApplicationState> getNodeStates() throws ClusterExecutionException;

    /**
     * @return {@code true} if clustering is available; otherwise, {@code false}
     */
    boolean isAvailable();

    /**
     * @return {@code true} if clustering is {@link #isAvailable() available} <i>and</i> at least two nodes have
     *         joined the cluster
     */
    boolean isClustered();

    /**
     * @return {@code true} if the current node is the leader node; also {@code true} if clustering is not enabled
     * @since 7.12
     */
    boolean isLeader();
}
