package com.atlassian.bitbucket.build.status;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when the build status is set.
 *
 * @since 7.6
 */
@AsynchronousPreferred
@TransactionAware
public class RepositoryBuildStatusSetEvent extends ApplicationEvent {

    private final RepositoryBuildStatus buildStatus;

    public RepositoryBuildStatusSetEvent(@Nonnull Object source, @Nonnull RepositoryBuildStatus buildStatus) {
        super(source);

        this.buildStatus = requireNonNull(buildStatus, "buildStatus");
    }

    /**
     * @return the {@link RepositoryBuildStatus build status} that was set
     */
    @Nonnull
    public RepositoryBuildStatus getBuildStatus() {
        return buildStatus;
    }

}
