package com.atlassian.bitbucket.build.status;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when the build status is removed.
 *
 * @since 7.19
 */
@AsynchronousPreferred
@TransactionAware
public class RepositoryBuildStatusDeletedEvent extends ApplicationEvent {

    private final RepositoryBuildStatus buildStatus;

    public RepositoryBuildStatusDeletedEvent(@Nonnull Object source, @Nonnull RepositoryBuildStatus buildStatus) {
        super(source);

        this.buildStatus = requireNonNull(buildStatus, "buildStatus");
    }

    /**
     * @return the {@link RepositoryBuildStatus build status} that was deleted
     */
    @Nonnull
    public RepositoryBuildStatus getBuildStatus() {
        return buildStatus;
    }
}
