package com.atlassian.bitbucket.build.status;

import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * A request to search for build statuses
 *
 * @since 7.6
 */
public final class BuildStatusRepositorySearchRequest extends AbstractBuildStatusSearchRequest {

    private final Ref ref;

    private BuildStatusRepositorySearchRequest(Builder builder) {
        super(builder);
        ref = builder.ref;
    }

    /**
     * Restrict the search to build statuses associated with this ref.
     *
     * @return the ref to restrict the search, or null to search across all refs
     */
    @Nullable
    public Ref getRef() {
        return ref;
    }

    public static class Builder extends AbstractBuilder<Builder> {

        private Ref ref;

        public Builder(@Nonnull Repository repository) {
            super(requireNonNull(repository, "repository"));
        }

        public Builder(@Nonnull BuildStatusRepositorySearchRequest request) {
            super(requireNonNull(request, "request"));
            ref = request.getRef();
        }

        @Override
        @Nonnull
        public BuildStatusRepositorySearchRequest build() {
            return new BuildStatusRepositorySearchRequest(this);
        }

        @Nonnull
        public Builder ref(@Nullable Ref ref) {
            this.ref = ref;

            return self();
        }

        @Nonnull
        @Override
        public Builder self() {
            return this;
        }
    }
}
