package com.atlassian.bitbucket.avatar;

import static org.apache.commons.lang3.StringUtils.trimToNull;

public abstract class AbstractAvatarSupplier implements AvatarSupplier {

    private final String contentType;

    protected AbstractAvatarSupplier() {
        this(null);
    }

    protected AbstractAvatarSupplier(String contentType) {
        this.contentType = trimToNull(contentType);
    }

    @Override
    public String getContentType() {
        return contentType;
    }
}
