package com.atlassian.bitbucket;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.server.Feature;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Indicates that there has been an attempt to run operation (i.e. use a {@link Feature})
 * that is unavailable.
 * An example would be a {@link Feature} that
 * requires certain type of license.
 *
 * @since 6.5
 */
public class FeatureUnavailableException extends ServiceException {

    private final Feature feature;

    public FeatureUnavailableException(@Nonnull KeyedMessage message, @Nonnull Feature feature) {
        super(message);
        this.feature = requireNonNull(feature, "feature");
    }

    @Nonnull
    public Feature getFeature() {
        return feature;
    }
}
