/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull.automerge;

import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AutoMergeSettingsCreateRequest {
    private final boolean enabled;
    private final Scope scope;

    private AutoMergeSettingsCreateRequest(Builder builder) {
        this.enabled = builder.enabled;
        this.scope = builder.scope;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder {
        private final boolean enabled;
        private final Scope scope;

        public Builder(@Nonnull ProjectScope scope, boolean enabled) {
            this.enabled = enabled;
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        public Builder(@Nonnull RepositoryScope scope, boolean enabled) {
            this.enabled = enabled;
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        @Nonnull
        public AutoMergeSettingsCreateRequest build() {
            return new AutoMergeSettingsCreateRequest(this);
        }
    }
}

