/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class PageImpl<T>
implements Page<T> {
    private final boolean lastPage;
    private final int nextPageStart;
    private final PageRequest pageRequest;
    private final int size;
    private final Iterable<T> values;

    public PageImpl(PageRequest pageRequest, int size, Iterable<T> values, boolean lastPage) {
        this(pageRequest, values, lastPage, size, pageRequest.getStart() + pageRequest.getLimit());
    }

    public PageImpl(PageRequest pageRequest, Iterable<T> values, boolean lastPage, int size, int nextPageStart) {
        this.lastPage = lastPage;
        this.nextPageStart = nextPageStart;
        this.pageRequest = pageRequest;
        this.size = size;
        this.values = values;
    }

    public PageImpl(PageRequest pageRequest, Iterable<T> values, boolean lastPage) {
        this(pageRequest, Iterables.size(values), values, lastPage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageImpl page = (PageImpl)o;
        return this.lastPage == page.lastPage && this.size == page.size && Objects.equals(this.pageRequest, page.pageRequest) && Objects.equals(this.values, page.values);
    }

    @Override
    public void forEach(@Nonnull Consumer<? super T> action) {
        this.values.forEach(action);
    }

    @Override
    public boolean getIsLastPage() {
        return this.lastPage;
    }

    @Override
    public int getLimit() {
        return this.pageRequest.getLimit();
    }

    @Override
    public PageRequest getNextPageRequest() {
        return this.getIsLastPage() ? null : new PageRequestImpl(this.getNextPageOffset(), this.getLimit());
    }

    @Override
    @Nonnull
    public SortedMap<Integer, T> getOrdinalIndexedValues() {
        TreeMap<Integer, T> valueMap = new TreeMap<Integer, T>();
        int index = this.getStart();
        for (T value : this.values) {
            valueMap.put(index++, value);
        }
        return valueMap;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getStart() {
        return this.pageRequest.getStart();
    }

    @Override
    @Nonnull
    public Iterable<T> getValues() {
        return this.values;
    }

    public int hashCode() {
        return Objects.hash(this.pageRequest, this.values, this.lastPage, this.size);
    }

    @Override
    @Nonnull
    public <E> PageImpl<E> transform(@Nonnull Function<? super T, ? extends E> transformFunction) {
        List list = MoreStreams.streamIterable(this.values).map(transformFunction).collect(MoreCollectors.toImmutableList());
        return new PageImpl(this.pageRequest, list, this.lastPage, this.size, this.nextPageStart);
    }

    protected int getNextPageOffset() {
        return this.nextPageStart;
    }
}

