/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.settingsrestriction;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SettingsKey {
    public static final int MIN_COMPONENT_KEY_LENGTH = 2;
    public static final int MAX_FEATURE_KEY_LENGTH = 255;
    public static final int MAX_NAMESPACE_LENGTH = 255;
    public static final int MAX_COMPONENT_KEY_LENGTH = 255;
    private final String componentKey;
    private final String featureKey;
    private final String namespace;

    private SettingsKey(Builder builder) {
        this.componentKey = builder.componentKey;
        this.featureKey = builder.featureKey;
        this.namespace = builder.namespace;
        SettingsKey.validate(this.namespace, this.featureKey, this.componentKey);
    }

    @Nonnull
    public Optional<String> getComponentKey() {
        return Optional.ofNullable(this.componentKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SettingsKey) {
            SettingsKey that = (SettingsKey)o;
            return Objects.equals(this.componentKey, that.componentKey) && Objects.equals(this.featureKey, that.featureKey) && Objects.equals(this.namespace, that.namespace);
        }
        return false;
    }

    @Nonnull
    public String getFeatureKey() {
        return this.featureKey;
    }

    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        return Objects.hash(this.featureKey, this.namespace, this.componentKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("namespace", (Object)this.namespace).add("featureKey", (Object)this.featureKey).add("componentKey", (Object)this.componentKey).toString();
    }

    private static void validate(String namespace, String featureKey, String componentKey) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)featureKey)) {
            validationErrors.add("The feature key can't be blank.");
        } else if (featureKey.length() > 255) {
            validationErrors.add("The feature key can't be longer than 255 characters.");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            validationErrors.add("The namespace can't be blank.");
        } else if (namespace.length() > 255) {
            validationErrors.add("The namespace can't be longer than 255 characters.");
        }
        if (componentKey != null) {
            if (StringUtils.isEmpty((CharSequence)componentKey)) {
                validationErrors.add("The component key can't be empty.");
            } else if (componentKey.length() < 2 || componentKey.length() > 255) {
                validationErrors.add("The component key must be between 2 and 255 characters in length.");
            }
        }
        if (!validationErrors.isEmpty()) {
            throw new IllegalArgumentException(String.join((CharSequence)" ", validationErrors));
        }
    }

    public static class Builder {
        private final String featureKey;
        private final String namespace;
        private String componentKey;

        @Nonnull
        public Builder(@Nonnull String namespace, @Nonnull String featureKey) {
            this.featureKey = Objects.requireNonNull(featureKey, "featureKey");
            this.namespace = Objects.requireNonNull(namespace, "namespace");
        }

        @Nonnull
        public SettingsKey build() {
            return new SettingsKey(this);
        }

        @Nonnull
        public Builder componentKey(@Nullable String componentKey) {
            this.componentKey = componentKey;
            return this;
        }
    }
}

