/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestFinishReviewRequest {
    private final String commentText;
    private final PullRequestParticipantStatus participantStatus;
    private final PullRequest pullRequest;
    private final int version;

    private PullRequestFinishReviewRequest(@Nonnull Builder builder) {
        this.commentText = builder.commentText;
        this.participantStatus = builder.participantStatus;
        this.pullRequest = builder.pullRequest;
        this.version = builder.version;
    }

    @Nullable
    public String getCommentText() {
        return this.commentText;
    }

    @Nullable
    public PullRequestParticipantStatus getParticipantStatus() {
        return this.participantStatus;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    public int getVersion() {
        return this.version;
    }

    public static class Builder {
        private final PullRequest pullRequest;
        private String commentText;
        private PullRequestParticipantStatus participantStatus;
        private int version;

        public Builder(@Nonnull PullRequest pullRequest) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        }

        @Nonnull
        public PullRequestFinishReviewRequest build() {
            return new PullRequestFinishReviewRequest(this);
        }

        @Nonnull
        public Builder commentText(@Nullable String value) {
            this.commentText = value;
            return this;
        }

        @Nonnull
        public Builder participantStatus(@Nullable PullRequestParticipantStatus value) {
            this.participantStatus = value;
            return this;
        }

        @Nonnull
        public Builder version(int value) {
            this.version = value;
            return this;
        }
    }
}

