/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.nav;

import com.atlassian.bitbucket.content.ArchiveFormat;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface NavBuilder {
    public static final String BASE_URL_KEY = "stash.baseUrl%";
    public static final String TOKEN_PREFIX = "$$$$";
    public static final String TOKEN_SUFFIX = "$$$$";
    public static final String BASE_URL_TOKEN = "$$$$stash.baseUrl%$$$$";
    public static final String USE_BASE_URL_TOKEN = "useBaseUrlToken";

    public String buildAbsolute();

    public String buildConfigured();

    public String buildBaseUrl();

    public String buildRelative();

    public Admin admin();

    public Builder<?> about();

    public PluginServlets pluginServlets();

    public Rest rest();

    public Tmp tmp();

    public Addons addons();

    public Project project(@Nonnull String var1);

    public Project project(@Nonnull com.atlassian.bitbucket.project.Project var1);

    public Repo repo(@Nonnull Repository var1);

    public Login login();

    public Builder<?> logout();

    public Builder<?> signup();

    public Builder<?> captcha();

    public Builder<?> retrievePassword();

    public Builder<?> passwordReset();

    public Profile profile();

    public Profile user(ApplicationUser var1);

    public Profile userBySlug(String var1, UserType var2);

    public Builder<?> securityCheck();

    public Builder<?> xsrfNotification();

    public Builder<?> setup();

    public ListProjects allProjects();

    public GlobalListRepos allRepos();

    public CreateProject createProject();

    public UserAccount account();

    public GettingStarted gettingStarted();

    public Dashboard dashboard();

    public static interface GettingStarted
    extends NavigationStep<GettingStarted> {
    }

    public static interface Login
    extends NavigationStep<Login> {
        @Nonnull
        public Login embedded();

        @Nonnull
        public Login admin();

        @Nonnull
        public Login sysadmin();
    }

    public static interface NavigationStep<B extends NavigationStep<B>>
    extends Builder<B> {
        @Nonnull
        public B next();

        @Nonnull
        public B next(@Nonnull String var1);
    }

    public static interface AddonRequests
    extends Builder<AddonRequests> {
        public Builder<?> category(String var1);
    }

    public static interface AddonMarketplace
    extends Builder<AddonMarketplace> {
        public Builder<?> category(String var1);
    }

    public static interface Addons
    extends Builder<Addons> {
        public Builder<?> manage();

        public AddonMarketplace marketplace();

        public AddonRequests requests();
    }

    public static interface Tmp
    extends Builder<Tmp> {
        public Builder<?> avatar(@Nonnull String var1);
    }

    public static interface ListPullRequests
    extends PagedBuilder<ListPullRequests> {
        public Builder<?> open();

        public Builder<?> declined();

        public Builder<?> merged();

        public ListPullRequests incoming();

        public ListPullRequests outgoing();
    }

    public static interface PullRequestOverview
    extends PagedBuilder<PullRequestOverview> {
    }

    public static interface PullRequestCommit
    extends PathBuilder<PullRequestCommit> {
        public PullRequestCommit since(@Nonnull String var1);
    }

    public static interface PullRequestComment
    extends Builder<PullRequestComment> {
        @Nonnull
        public PullRequestComment like();

        @Nonnull
        public PullRequestComment reply();
    }

    public static interface PullRequestBuilds
    extends Builder<PullRequestBuilds> {
    }

    public static interface PullRequestActivity
    extends Builder<PullRequestActivity> {
    }

    public static interface PullRequest
    extends Builder<PullRequest> {
        @Nonnull
        public PullRequestActivity activity(long var1);

        @Nonnull
        public PullRequestBuilds builds();

        @Nonnull
        public PullRequestComment comment(long var1);

        @Nonnull
        public PullRequestCommit commit(@Nonnull String var1);

        public PagedBuilder<?> commits();

        public Builder<?> diff();

        public PullRequestOverview overview();

        public Builder<?> unreviewed();

        public PagedBuilder<?> unwatch();
    }

    public static interface CreatePullRequest
    extends Builder<CreatePullRequest> {
        public CreatePullRequest sourceBranch(String var1);

        public CreatePullRequest targetBranch(String var1);
    }

    public static interface RepoSecretScanning
    extends Builder<RepoSecretScanning> {
    }

    public static interface RepoReviewerGroupsSettings
    extends Builder<RepoReviewerGroupsSettings> {
    }

    public static interface RepoRequiredBuildsSettings
    extends Builder<RepoRequiredBuildsSettings> {
    }

    public static interface RepoPullRequestTemplateSettings
    extends Builder<RepoPullRequestTemplateSettings> {
    }

    public static interface RepoMergeStrategySettings
    extends Builder<RepoMergeStrategySettings> {
    }

    public static interface RepoDefaultTasksSettings
    extends Builder<RepoDefaultTasksSettings> {
    }

    public static interface RepoAutoMergeSettings
    extends Builder<RepoAutoMergeSettings> {
    }

    public static interface RepoAutoDeclineSettings
    extends Builder<RepoAutoDeclineSettings> {
    }

    public static interface RepoPushLog
    extends Builder<RepoPushLog> {
    }

    public static interface RepoFork
    extends Builder<RepoFork> {
    }

    public static interface RevisionBrowse
    extends PathBuilder<RevisionBrowse> {
    }

    public static interface RepoDelete
    extends Builder<RepoDelete> {
    }

    public static interface RepoMergeChecks
    extends Builder<RepoMergeChecks> {
    }

    public static interface RepoHooks
    extends Builder<RepoHooks> {
    }

    public static interface PullRequestRepoSettings
    extends Builder<PullRequestRepoSettings> {
    }

    public static interface RepoPermissions
    extends Builder<RepoPermissions> {
    }

    public static interface RepoSettings
    extends Builder<RepoSettings> {
        public RepoAutoDeclineSettings autoDecline();

        public RepoAutoMergeSettings autoMerge();

        public RepoDefaultTasksSettings defaultTasks();

        public PullRequestRepoSettings pullRequests();

        public RepoMergeStrategySettings mergeStrategies();

        public RepoPullRequestTemplateSettings pullRequestTemplates();

        public RepoRequiredBuildsSettings requiredBuilds();

        public RepoReviewerGroupsSettings reviewerGroups();

        public RepoSecretScanning secretScanning();
    }

    public static interface CompareBuilder<T extends CompareBuilder<T>>
    extends Builder<T> {
        public CompareBuilder<T> sourceBranch(@Nonnull String var1);

        public CompareBuilder<T> targetBranch(@Nonnull String var1);
    }

    public static interface Compare
    extends CompareBuilder<Compare>,
    PathBuilder<Compare> {
        public CommitsBuilder commits();

        public DiffBuilder diff();

        public static interface DiffBuilder
        extends CompareBuilder<DiffBuilder> {
        }

        public static interface CommitsBuilder
        extends CompareBuilder<CommitsBuilder> {
        }
    }

    public static interface RevisionBuilds
    extends PathBuilder<RevisionBuilds> {
    }

    public static interface RepoBuilds
    extends Builder<RepoBuilds> {
        public RevisionBuilds atRevision(@Nullable String var1);

        public RevisionBuilds atRevision(@Nonnull Ref var1);
    }

    public static interface RepoAttachmentMetadata
    extends Builder<RepoAttachmentMetadata> {
    }

    public static interface RepoAttachment
    extends Builder<RepoAttachment> {
        @Nonnull
        public RepoAttachmentMetadata metadata();
    }

    public static interface RepoArchive
    extends Builder<RepoArchive> {
        @Nonnull
        public RepoArchive commitId(@Nonnull String var1);

        @Nonnull
        public RepoArchive filename(@Nonnull String var1);

        @Nonnull
        public RepoArchive format(@Nonnull ArchiveFormat var1);

        @Nonnull
        public RepoArchive path(@Nullable String var1);

        @Nonnull
        public RepoArchive paths(@Nullable String var1, String ... var2);

        @Nonnull
        public RepoArchive paths(@Nullable Iterable<String> var1);

        @Nonnull
        public RepoArchive prefix(@Nonnull String var1);
    }

    public static interface CommitComment
    extends Builder<CommitComment> {
    }

    public static interface Commit
    extends PathBuilder<Commit> {
        @Nonnull
        public Commit change(@Nonnull Path var1);

        @Nonnull
        public Commit change(@Nonnull String var1);

        @Nonnull
        public CommitComment comment(long var1);

        @Nonnull
        public Commit unwatch();
    }

    public static interface ListForks
    extends PagedBuilder<ListForks> {
    }

    public static interface ListCommits
    extends PagedBuilder<ListCommits> {
        public ListCommits until(@Nonnull Ref var1);

        public ListCommits until(@Nonnull String var1);
    }

    public static interface ListTags
    extends PagedBuilder<ListTags> {
    }

    public static interface ListBranches
    extends PagedBuilder<ListBranches> {
    }

    public static interface CreateRepo
    extends Builder<CreateRepo> {
    }

    public static interface BrowseRepoResource
    extends PathBuilder<BrowseRepoResource> {
        public RevisionBrowse atRevision(@Nullable String var1);

        public RevisionBrowse atRevision(@Nonnull Ref var1);
    }

    public static interface Repo
    extends Builder<Repo> {
        @Nonnull
        public RepoArchive archive();

        @Nonnull
        public RepoAttachment attachment(@Nonnull String var1);

        @Nonnull
        public RepoAttachment attachment(long var1);

        @Nonnull
        public BrowseRepoResource browse();

        @Nonnull
        public ListBranches branches();

        @Nonnull
        public RepoBuilds builds();

        @Nonnull
        public ListTags tags();

        @Nonnull
        public Commit commit(@Nonnull String var1);

        @Nonnull
        public ListCommits commits();

        @Nonnull
        public Compare compare();

        @Nonnull
        public ListForks forks();

        @Nonnull
        public RepoSettings settings();

        @Nonnull
        public RepoHooks hooks();

        @Nonnull
        public RepoMergeChecks mergeChecks();

        @Nonnull
        public RepoPermissions permissions();

        @Nonnull
        public RepoDelete delete();

        @Nonnull
        public RepoFork fork();

        @Nonnull
        public RepoPushLog pushLog();

        @Nonnull
        public CreatePullRequest createPullRequest();

        @Nonnull
        public PullRequest pullRequest(long var1);

        @Nonnull
        public ListPullRequests pullRequests();
    }

    public static interface ProjectSecretScanning
    extends Builder<ProjectSecretScanning> {
    }

    public static interface ProjectReviewerGroupSettings
    extends Builder<ProjectReviewerGroupSettings> {
    }

    public static interface ProjectPermissions
    extends Builder<ProjectPermissions> {
    }

    public static interface ProjectPullRequestTemplateSettings
    extends Builder<ProjectPullRequestTemplateSettings> {
    }

    public static interface ProjectMergeStrategySettings
    extends Builder<ProjectMergeStrategySettings> {
    }

    public static interface ProjectDefaultTasksSettings
    extends Builder<ProjectDefaultTasksSettings> {
    }

    public static interface ProjectAutoMergeSettings
    extends Builder<ProjectAutoMergeSettings> {
    }

    public static interface ProjectAutoDeclineSettings
    extends Builder<ProjectAutoDeclineSettings> {
    }

    public static interface ProjectDelete
    extends Builder<ProjectDelete> {
    }

    public static interface CreateProject
    extends Builder<CreateProject> {
    }

    public static interface ProjectSettings
    extends Builder<ProjectSettings> {
        public ProjectAutoDeclineSettings autoDecline();

        public ProjectAutoMergeSettings autoMerge();

        public ProjectDefaultTasksSettings defaultTasks();

        public ProjectMergeStrategySettings mergeStrategies(@Nonnull String var1);

        public ProjectPullRequestTemplateSettings pullRequestTemplates();

        public ProjectReviewerGroupSettings reviewerGroups();
    }

    public static interface ProjectMergeChecks
    extends Builder<ProjectMergeChecks> {
    }

    public static interface ProjectHooks
    extends Builder<ProjectHooks> {
    }

    public static interface ListRepos
    extends PagedBuilder<ListRepos> {
    }

    public static interface Project
    extends Builder<Project> {
        public Builder<?> avatar(int var1);

        public ProjectHooks hooks();

        public ProjectMergeChecks mergeChecks();

        public ListRepos repos();

        public Repo repo(@Nonnull String var1);

        public Repo repo(@Nonnull Repository var1);

        public CreateRepo createRepo();

        public ProjectSettings settings();

        public ProjectDelete delete();

        public ProjectPermissions permissions();

        public ProjectSecretScanning secretScanning();
    }

    public static interface GlobalListRepos
    extends Builder<GlobalListRepos> {
        public GlobalListRepos privateVisibility();

        public GlobalListRepos publicVisibility();

        public GlobalListRepos visibility(RepositoryVisibility var1);
    }

    public static interface ListProjects
    extends PagedBuilder<ListProjects> {
    }

    public static interface RestAdmin
    extends Builder<RestAdmin> {
        public Builder<?> users();
    }

    public static interface RestUser
    extends Builder<RestUser> {
        public Builder<?> avatar();
    }

    public static interface RestUsers
    extends Builder<RestUsers> {
    }

    public static interface RestHook
    extends Builder<RestHook> {
        public Builder<?> avatar(@Nullable String var1);
    }

    public static interface RestHooks
    extends Builder<RestHooks> {
        public RestHook hook(@Nonnull String var1);
    }

    public static interface Rest
    extends Builder<Rest> {
        public RestAdmin admin();

        public RestUsers users();

        public RestUser users(String var1);

        public Builder<?> pullRequest(long var1);

        public RestHooks hooks();
    }

    public static interface PluginServlets
    extends PathBuilder<PluginServlets> {
        public Builder<?> oauthTokens();

        public Builder<?> notificationSettings();

        public Builder<?> repositoryNotificationSettings();
    }

    public static interface ViewGroup
    extends Builder<ViewGroup> {
    }

    public static interface DeleteGroup
    extends Builder<DeleteGroup> {
    }

    public static interface Groups
    extends PagedBuilder<Groups> {
        public Builder<?> create();

        public DeleteGroup delete(String var1);

        public ViewGroup view(String var1);

        public Groups filter(String var1);
    }

    public static interface DeleteUser
    extends Builder<DeleteUser> {
    }

    public static interface ViewUser
    extends Builder<ViewUser> {
        public Builder<?> listSshKeys();
    }

    public static interface Users
    extends PagedBuilder<Users> {
        public Builder<?> anonymize();

        public Builder<?> create();

        public DeleteUser delete(String var1);

        public ViewUser view(String var1);

        public Users filter(String var1);

        public Builder<?> captcha(String var1);
    }

    public static interface KeysAndTokens
    extends Builder<KeysAndTokens> {
    }

    public static interface Mesh
    extends Builder<Mesh> {
    }

    public static interface Licensing
    extends Builder<Licensing> {
        public Builder<?> edit();
    }

    public static interface JiraCloudIntegration
    extends Builder<JiraCloudIntegration> {
        public Builder<?> jiraCloud();
    }

    public static interface GitAdmin
    extends Builder<GitAdmin> {
        public Builder<?> defaultBranch();

        public Mesh mesh();
    }

    public static interface Database
    extends Builder<Database> {
        public Builder<?> migrate();
    }

    public static interface Admin
    extends Builder<Admin> {
        public Users users();

        public Groups groups();

        public Builder<?> security();

        public Builder<?> plugins();

        public Builder<?> settings();

        public Builder<?> permissions();

        public Builder<?> avatars();

        public Builder<?> authentication();

        public Builder<?> mailServer();

        public Builder<?> appLinks();

        public Builder<?> serverSettings();

        public Database database();

        public Builder<?> storage();

        public Licensing licensing();

        public Builder<?> i18n();

        public Builder<?> logging();

        public Builder<?> monitoring();

        public Builder<?> sysInfo();

        public Builder<?> clustering();

        public Builder<?> rateLimitSettings();

        public Builder<?> mirrors();

        public GitAdmin git();

        public JiraCloudIntegration jiraCloudIntegration();

        public Builder<?> repositoryManagement();

        public Builder<?> secretScanning();

        public KeysAndTokens keysAndTokens();
    }

    public static interface UserAccount
    extends Builder<UserAccount> {
        public Builder<?> settings();

        public Builder<?> password();
    }

    public static interface Profile
    extends Builder<Profile> {
        public Builder<?> avatar(int var1);

        public Builder<?> listSshKeys();
    }

    public static interface Dashboard
    extends Builder<Dashboard> {
    }

    public static interface PathBuilder<B extends PathBuilder<B>>
    extends Builder<B> {
        public PathBuilder<B> path(String ... var1);

        public PathBuilder<B> path(@Nonnull Path var1);
    }

    public static interface PagedBuilder<B extends PagedBuilder<B>>
    extends Builder<B> {
        public PagedBuilder<B> startAt(int var1);

        public PagedBuilder<B> withLimit(int var1);
    }

    public static interface Builder<B extends Builder<B>> {
        public B withParam(@Nonnull String var1, String var2);

        public String buildRelative();

        public String buildRelNoContext();

        public String buildAbsolute();

        public String buildConfigured();
    }
}

