/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AbstractDiffCommandParameters
extends AbstractCommandParameters {
    public static final int DEFAULT_CONTEXT_LINES = -1;
    private static final int MIN_LINE_LENGTH = 100;
    private final int contextLines;
    private final int maxLineLength;
    private final int maxLines;
    private final Set<String> paths;
    private final Repository secondaryRepository;
    private final DiffWhitespace whitespace;

    protected AbstractDiffCommandParameters(AbstractBuilder<?> builder) {
        this.contextLines = ((AbstractBuilder)builder).contextLines;
        this.maxLineLength = Math.max(((AbstractBuilder)builder).maxLineLength, 100);
        this.maxLines = ((AbstractBuilder)builder).maxLines;
        this.paths = ((AbstractBuilder)builder).paths.build();
        this.secondaryRepository = ((AbstractBuilder)builder).secondaryRepository;
        this.whitespace = ((AbstractBuilder)builder).whitespace;
    }

    public int getContextLines() {
        return this.contextLines;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    public boolean hasContextLines() {
        return this.contextLines != -1;
    }

    public boolean hasPaths() {
        return !this.paths.isEmpty();
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    @Nonnull
    protected DiffContext toContext(@Nonnull DiffContext.Builder builder) {
        return Objects.requireNonNull(builder, "builder").contextLines(this.getContextLines()).maxLineLength(this.getMaxLineLength()).maxLines(this.getMaxLines()).whitespace(this.getWhitespace()).build();
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private int contextLines = -1;
        private int maxLineLength;
        private int maxLines;
        private Repository secondaryRepository;
        private DiffWhitespace whitespace = DiffWhitespace.SHOW;

        @Nonnull
        public B contextLines(int value) {
            this.contextLines = value;
            return this.self();
        }

        @Nonnull
        public B defaultContextLines() {
            this.contextLines = -1;
            return this.self();
        }

        @Nonnull
        public B maxLineLength(int value) {
            this.maxLineLength = value;
            return this.self();
        }

        @Nonnull
        public B maxLines(int value) {
            this.maxLines = value;
            return this.self();
        }

        @Nonnull
        public B path(@Nullable String value) {
            AbstractDiffCommandParameters.addIf(NOT_BLANK, this.paths, value);
            return this.self();
        }

        @Nonnull
        public B paths(@Nullable Iterable<String> values) {
            AbstractDiffCommandParameters.addIf(NOT_BLANK, this.paths, values);
            return this.self();
        }

        @Nonnull
        public B paths(@Nullable String value, String ... values) {
            AbstractDiffCommandParameters.addIf(NOT_BLANK, this.paths, value, values);
            return this.self();
        }

        @Nonnull
        public B secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this.self();
        }

        @Nonnull
        public B whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = Objects.requireNonNull(value, "whitespace");
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

