/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.FilePermission;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class SetFilePermissionRequest {
    private final Set<FilePermission> groupPermissions;
    private final Set<FilePermission> ownerPermissions;
    private final Path path;
    private final Set<FilePermission> worldPermissions;

    private SetFilePermissionRequest(@Nonnull Builder builder) {
        this.groupPermissions = builder.groupPermissions.build();
        this.ownerPermissions = builder.ownerPermissions.build();
        this.path = builder.path;
        this.worldPermissions = builder.worldPermissions.build();
    }

    @Nonnull
    public Set<FilePermission> getGroupPermissions() {
        return this.groupPermissions;
    }

    @Nonnull
    public Set<FilePermission> getOwnerPermissions() {
        return this.ownerPermissions;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    @Nonnull
    public Set<FilePermission> getWorldPermissions() {
        return this.worldPermissions;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<FilePermission> groupPermissions;
        private final ImmutableSet.Builder<FilePermission> ownerPermissions;
        private final Path path;
        private final ImmutableSet.Builder<FilePermission> worldPermissions;

        public Builder(@Nonnull Path path) {
            this.path = Objects.requireNonNull(path, "path");
            this.groupPermissions = ImmutableSet.builder();
            this.ownerPermissions = ImmutableSet.builder();
            this.worldPermissions = ImmutableSet.builder();
        }

        @Nonnull
        public SetFilePermissionRequest build() {
            return new SetFilePermissionRequest(this);
        }

        @Nonnull
        public Builder groupPermission(@Nonnull FilePermission permission) {
            Builder.addIf(Objects::nonNull, this.groupPermissions, permission);
            return this;
        }

        @Nonnull
        public Builder groupPermissions(@Nonnull Iterable<FilePermission> permissions) {
            Builder.addIf(Objects::nonNull, this.groupPermissions, permissions);
            return this;
        }

        @Nonnull
        public Builder ownerPermission(@Nonnull FilePermission permission) {
            Builder.addIf(Objects::nonNull, this.ownerPermissions, permission);
            return this;
        }

        @Nonnull
        public Builder ownerPermissions(@Nonnull Iterable<FilePermission> permissions) {
            Builder.addIf(Objects::nonNull, this.ownerPermissions, permissions);
            return this;
        }

        @Nonnull
        public Builder worldPermission(@Nonnull FilePermission permission) {
            Builder.addIf(Objects::nonNull, this.worldPermissions, permission);
            return this;
        }

        @Nonnull
        public Builder worldPermissions(@Nonnull Iterable<FilePermission> permissions) {
            Builder.addIf(Objects::nonNull, this.worldPermissions, permissions);
            return this;
        }
    }
}

