/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.content.PatchRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class PatchCommandParameters
extends AbstractCommandParameters {
    private final boolean allAncestors;
    private final Repository secondaryRepository;
    private final String sinceId;
    private final String untilId;

    private PatchCommandParameters(Builder builder) {
        this.allAncestors = builder.allAncestors;
        this.secondaryRepository = builder.secondaryRepository;
        this.sinceId = builder.sinceId;
        this.untilId = builder.untilId;
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    public boolean isAllAncestors() {
        return this.allAncestors;
    }

    public static class Builder {
        private boolean allAncestors;
        private Repository secondaryRepository;
        private String sinceId;
        private String untilId;

        public Builder() {
        }

        public Builder(@Nonnull PatchRequest patchRequest) {
            Objects.requireNonNull(patchRequest, "patchRequest");
            this.allAncestors = patchRequest.isAllAncestors();
            this.secondaryRepository = patchRequest.getSecondaryRepository();
            this.sinceId = patchRequest.getSinceId();
            this.untilId = patchRequest.getUntilId();
        }

        @Nonnull
        public Builder allAncestors(boolean value) {
            this.allAncestors = value;
            return this;
        }

        @Nonnull
        public PatchCommandParameters build() {
            if (StringUtils.isBlank((CharSequence)this.untilId)) {
                throw new IllegalStateException("An \"untilId\" is required to build a patch");
            }
            return new PatchCommandParameters(this);
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this;
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = value;
            return this;
        }

        @Nonnull
        public Builder untilId(@Nonnull String value) {
            this.untilId = value;
            return this;
        }
    }
}

