/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.Progress;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ProgressImpl
implements Progress,
Serializable {
    private final String message;
    private final int percentage;

    public ProgressImpl(@Nonnull String message, @Nonnegative int percentage) {
        Objects.requireNonNull(message, "message cannot be null");
        Preconditions.checkArgument((percentage >= 0 ? 1 : 0) != 0, (Object)"percentage cannot be negative");
        Preconditions.checkArgument((percentage <= 100 ? 1 : 0) != 0, (Object)"percentage cannot greater than 100");
        this.message = message;
        this.percentage = percentage;
    }

    public ProgressImpl(@Nonnull Progress progress) {
        this(Objects.requireNonNull(progress, "progress").getMessage(), progress.getPercentage());
    }

    @Override
    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nonnegative
    public int getPercentage() {
        return this.percentage;
    }

    public String toString() {
        return this.message + " (" + this.percentage + ")";
    }
}

