package com.atlassian.bitbucket.task;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Allows the update of a {@link Task task}.
 *
 * @see TaskService#update(TaskUpdateRequest)
 * @deprecated in 7.0 for removal in 8.0. Tasks are now managed using {@link com.atlassian.bitbucket.comment.Comment
 *             comments} with {@link com.atlassian.bitbucket.comment.CommentSeverity#BLOCKER BLOCKER} severity.
 */
@Deprecated
public class TaskUpdateRequest {

    private final TaskState state;
    private final Task task;
    private final String text;

    private TaskUpdateRequest(Builder builder) {
        this.state = builder.state;
        this.task = requireNonNull(builder.task, "task");
        this.text = builder.text;
    }

    @Nullable
    public TaskState getState() {
        return state;
    }

    @Nonnull
    public Task getTask() {
        return task;
    }

    @Nullable
    public String getText() {
        return text;
    }

    public static class Builder {

        private final Task task;
        private TaskState state;
        private String text;

        public Builder(@Nonnull Task task) {
            this.task = requireNonNull(task, "task");
        }

        public TaskUpdateRequest build() {
            return new TaskUpdateRequest(this);
        }

        public Builder state(@Nonnull TaskState value) {
            this.state = requireNonNull(value, "state");
            return this;
        }

        public Builder text(@Nonnull String value) {
            this.text = requireNonNull(value, "text");
            return this;
        }
    }
}
