package com.atlassian.bitbucket.task;

/**
 * Enumerates the possible {@link Task#getState() states} a task can be in.
 *
 * @see Task#getState()
 * @deprecated in 7.0 for removal in 8.0. Tasks are now managed using {@link com.atlassian.bitbucket.comment.Comment
 *             comments} with {@link com.atlassian.bitbucket.comment.CommentSeverity#BLOCKER BLOCKER} severity.
 */
@Deprecated
public enum TaskState {

    /**
     * The {@link Task task} is open.
     */
    OPEN(0),
    /**
    * The {@link Task task} has been resolved.
    */
    RESOLVED(1);

    private final int id;

    TaskState(int id) {
        this.id = id;
    }

    public static TaskState fromId(int id) {
        for (TaskState value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No TaskState is associated with ID [" + id + "]");
    }

    public int getId() {
        return id;
    }
}
