package com.atlassian.bitbucket.task;

import com.atlassian.bitbucket.util.BuilderSupport;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * Allows the creation of a {@link Task task}.
 *
 * @see TaskService#create(TaskCreateRequest)
 * @deprecated in 7.0 for removal in 8.0. Tasks are now managed using {@link com.atlassian.bitbucket.comment.Comment
 *             comments} with {@link com.atlassian.bitbucket.comment.CommentSeverity#BLOCKER BLOCKER} severity.
 */
@Deprecated
public class TaskCreateRequest {

    private final long anchorId;
    private final TaskAnchorType anchorType;
    private final String text;

    private TaskCreateRequest(Builder builder) {
        checkArgument(builder.anchorId > 0, "anchorId");
        checkArgument(isNotBlank(builder.text), "Task text cannot be blank");

        anchorType = requireNonNull(builder.anchorType, "anchorType");
        anchorId = builder.anchorId;
        text = builder.text;
    }

    public long getAnchorId() {
        return anchorId;
    }

    @Nonnull
    public TaskAnchorType getAnchorType() {
        return anchorType;
    }

    @Nonnull
    public String getText() {
        return text;
    }

    public static class Builder extends BuilderSupport {

        private long anchorId;
        private TaskAnchorType anchorType;
        private String text;

        @Nonnull
        public Builder anchorId(long value) {
            checkArgument(value > 0, "anchor id");
            anchorId = value;
            return this;
        }

        @Nonnull
        public Builder anchorType(@Nonnull TaskAnchorType value) {
            anchorType = requireNonNull(value, "anchor");
            return this;
        }

        @Nonnull
        public Builder text(@Nonnull String value) {
            text = checkNotBlank(value, "text");
            return this;
        }

        @Nonnull
        public TaskCreateRequest build() {
            return new TaskCreateRequest(this);
        }
    }
}
