package com.atlassian.bitbucket.server;

import javax.annotation.Nonnull;

/**
 * Identifies a feature that can be enabled or disabled through {@code bitbucket.properties}
 *
 * @see FeatureManager
 * @see StandardFeature
 * @since 4.2
 */
public interface Feature {

    /**
     * @return identifier for the feature
     */
    @Nonnull
    String getKey();

    /**
     * @return {@code true} if the feature requires a Data Center license, otherwise {@code false}
     */
    boolean isDataCenter();
}
