package com.atlassian.bitbucket.scope;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.0
 */
public class Scopes {

    private static final GlobalScope GLOBAL = new GlobalScope();

    private Scopes() {
        throw new UnsupportedOperationException(getClass().getName() +
                " is a utility class and should not be instantiated");
    }

    /**
     * @return the global scope
     */
    @Nonnull
    public static GlobalScope global() {
        return GLOBAL;
    }

    /**
     * @param project project to create scope for
     * @return a project level scope for the given {@code project}
     */
    @Nonnull
    public static ProjectScope project(@Nonnull Project project) {
        return new ProjectScope(requireNonNull(project, "project"));
    }

    /**
     * @param repository to create the scope for
     * @return a repository level scope for the given {@code repository}
     */
    @Nonnull
    public static RepositoryScope repository(@Nonnull Repository repository) {
        return new RepositoryScope(requireNonNull(repository, "repository"));
    }
}
