package com.atlassian.bitbucket.scope;

import javax.annotation.Nonnull;

/**
 * Enumerates the available scopes.
 *
 * @since 5.0
 */
public enum ScopeType {

    GLOBAL(0),
    PROJECT(1),
    REPOSITORY(2);

    private final int id;

    ScopeType(int id) {
        this.id = id;
    }

    /**
     * @param id the {@link #getId() unique identifier} for the type (<i>not</i> its {@link #ordinal()})
     * @return the matching type
     * @throws IllegalArgumentException if the specified ID does not match a type
     * @since 5.1
     */
    @Nonnull
    public static ScopeType fromId(int id) {
        for (ScopeType value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No ScopeType is associated with ID [" + id + "]");
    }

    /**
     * @return the ID
     * @since 5.1
     */
    public int getId() {
        return id;
    }
}
