package com.atlassian.bitbucket.scm.signed;

import javax.annotation.Nonnull;
import java.util.Iterator;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.1
 */
public class SimpleSignedObjectIdSource implements SignedObjectIdSource {

    private final Iterator<String> delegate;

    public SimpleSignedObjectIdSource(@Nonnull Iterable<String> iterable) {
        this.delegate = requireNonNull(iterable, "iterable").iterator();
    }

    @Override
    public boolean hasNext() {
        return delegate.hasNext();
    }

    @Nonnull
    @Override
    public String next() {
        return delegate.next();
    }
}
