package com.atlassian.bitbucket.scm;

import com.atlassian.utils.process.OutputHandler;

/**
 * Describes an {@code OutputHandler} which processes the standard error stream from a {@link Command}. Unlike a
 * {@link CommandOutputHandler}, error handlers are not expected to perform parsing which results in an object graph.
 * As a result, the contract of this interface does not mandate a method for retrieving output.
 * <p>
 * Note: Providing an error handler to a {@link Command} prevents the {@link CommandExitHandler} from receiving output
 * written to standard error when the command exits or is canceled. When using an error handler, it is <i>required</i>
 * that all processing related to the standard error stream be performed in the error handler.
 *
 * @see CommandAware
 */
public interface CommandErrorHandler extends OutputHandler {
}
