package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;

/**
 * A minimal abstraction for a ref change, describing only the {@link MinimalRef ref} and the
 * {@link RefChangeType change type}.
 *
 * @since 7.11
 */
public interface MinimalRefChange {

    /**
     * @return the ref that has been updated
     */
    @Nonnull
    MinimalRef getRef();

    /**
     * @return the type of ref change
     */
    @Nonnull
    RefChangeType getType();
}
