package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.setting.Settings;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Request object used for {@link RepositoryHookService#setSettings(SetRepositoryHookSettingsRequest) updating settings for a repository hook}.
 *
 * @since 5.2
 */
public class SetRepositoryHookSettingsRequest extends AbstractUpdateRepositoryHookRequest {

    private final Settings settings;

    private SetRepositoryHookSettingsRequest(Builder builder) {
        super(builder);
        settings = builder.settings;
    }

    @Nonnull
    public Settings getSettings() {
        return settings;
    }

    public static class Builder extends AbstractBuilder {

        private Settings settings;

        public Builder(@Nonnull Scope scope, @Nonnull String hookKey) {
            super(scope, hookKey);
        }

        @Nonnull
        public SetRepositoryHookSettingsRequest build() {
            requireNonNull(settings, "settings");
            return new SetRepositoryHookSettingsRequest(this);
        }

        @Nonnull
        public Builder settings(@Nonnull Settings value) {
            settings = requireNonNull(value, "settings");
            return this;
        }
    }
}
