package com.atlassian.bitbucket.event.request;

import com.atlassian.bitbucket.request.RequestContext;

/**
 * Dispatched to indicate a request has started.
 */
public class RequestStartedEvent extends RequestEvent {

    /**
     * Constructs a new {@code RequestStartedEvent}, providing the event's source and the RequestContext for the
     * request that was started.
     *
     * @param source  the event source
     * @param requestContext the RequestContext for the started request
     */
    public RequestStartedEvent(Object source, RequestContext requestContext) {
        super(source, requestContext);
    }
}
