package com.atlassian.bitbucket.event.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Raised when the default branch of a repository is reconfigured (typically through repository settings).
 */
@AsynchronousPreferred
@EventName("stash.repository.defaultbranchmodified")
public class RepositoryDefaultBranchModifiedEvent extends RepositoryEvent {

    private final String newValue;
    private final String oldValue;

    /**
     * @deprecated in 7.4 for removal in 8.0.
     * {@link #RepositoryDefaultBranchModifiedEvent(Object, Repository, String, String)} should be used instead.
     */
    @Deprecated
    public RepositoryDefaultBranchModifiedEvent(@Nonnull Object source, @Nonnull Repository repository,
                                                @Nonnull String newValue) {
        super(source, repository);
        this.newValue = requireNonNull(newValue, "newValue");
        oldValue = null;
    }

    /**
     * @since 7.4
     */
    public RepositoryDefaultBranchModifiedEvent(@Nonnull Object source, @Nonnull Repository repository,
                                                @Nonnull String newValue, @Nonnull String oldValue) {
        super(source, repository);
        this.newValue = requireNonNull(newValue, "newValue");
        this.oldValue = requireNonNull(oldValue, "oldValue");
    }

    @Nonnull
    public String getNewValue() {
        return newValue;
    }

    @Nullable
    public String getOldValue() {
        return oldValue;
    }
}
